/* uriQuery.js
 * Utilities for working with the URI query string
 * Copyright UCLES 2008. */

/* Dependencies:
 * jquery-1.2.1.js */

$(function () {
	// decode the query string passed to the current document.
	uriQuery.query = uriQuery.decode(window.location.search);
});

var uriQuery = {
	/** The query string passed to the current document in decoded form */
	query: {},
	
	/** Decodes a query string into a map of keys to values. The query string
	 * may or may not include a preceding "?". */
	decode: function (queryString) {
		var query = {};
		if (queryString.charAt(0) == "?") queryString = queryString.substr(1);
		var queryArr = queryString.split("&");
		for (var i=0; i<queryArr.length; ++i) {
			var keyValue = queryArr[i].split("=");
			var key = decodeURIComponent(keyValue[0]);
			var value = decodeURIComponent(keyValue[1]);
			query[key] = value;
		}
		return query;
	},
	
	/** Encodes a map of keys to values into a query string, which will
	 * include a preceding "?". */
	encode: function (query) {
		var queryArr = [];
		for (key in query) {
			var value = query[key];
			var queryItem = [
				encodeURIComponent(key),
				encodeURIComponent(value)
			];
			queryArr.push(queryItem.join("="));
		}
		return "?" + queryArr.join("&");
	}
}; 
